package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEvent();
            findCurrentEvent();
            findTodayEvent();
            findEventCreatedNow();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void persistEvent() {
        ScheduledEvent e1 = ScheduledEvent.create("Test event",
                LocalDate.of(2018, 6, 1),
                LocalTime.of(9, 30, 45),
                LocalTime.of(11, 45, 30),
                LocalDateTime.now().minusDays(10));

        ScheduledEvent e2 = ScheduledEvent.create("Test event2",
                LocalDate.now(),
                LocalTime.of(9, 30, 45),
                LocalTime.of(20, 45, 30),
                LocalDateTime.now().minusMonths(1));

        ScheduledEvent e3 = ScheduledEvent.create("Test event3",
                LocalDate.now(),
                LocalTime.of(18, 0, 0),
                LocalTime.of(20, 0, 0),
                LocalDateTime.now());

        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(e1);
        em.persist(e2);
        em.persist(e3);
        em.getTransaction().commit();

        System.out.println("-- all persisted entities --");
        em.createQuery("SELECT e FROM ScheduledEvent e")
          .getResultList()
          .forEach(System.out::println);
        em.close();
    }

    private static void findCurrentEvent() {
        System.out.println("-- current ongoing event  --");
        EntityManager em = entityManagerFactory.createEntityManager();
        List list = em
                .createQuery("SELECT e FROM ScheduledEvent e WHERE CURRENT_DATE = e.date AND "
                        + "CURRENT_TIME BETWEEN e.start AND e.end")
                .getResultList();
        list.forEach(System.out::println);
        em.close();
    }

    private static void findTodayEvent() {
        System.out.println("-- today event  --");
        EntityManager em = entityManagerFactory.createEntityManager();
        List list = em
                .createQuery("SELECT e FROM ScheduledEvent e WHERE  CURRENT_DATE = e.date")
                .getResultList();
        list.forEach(System.out::println);
        em.close();
    }

    private static void findEventCreatedNow() {
        System.out.println("-- event created within 10 sec --");
        EntityManager em = entityManagerFactory.createEntityManager();
        List list = em
                .createQuery("SELECT e FROM ScheduledEvent e WHERE e.eventCreated BETWEEN :timestampStart "
                        + "AND CURRENT_TIMESTAMP")
                .setParameter("timestampStart", Timestamp.valueOf(LocalDateTime.now().minusSeconds(10)))
                .getResultList();
        list.forEach(System.out::println);
        em.close();
    }
}