package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findAllEmployees();
            findEmployeeByPhone();
            findEmployeeByPhones();
            findEmployeeByPhones2();
            findEmployeeByTask();
            findEmployeeByTasks();
            findEmployeeByTasks2();

        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Task task1 = Task.create("Refactoring", "Rose");
        Task task2 = Task.create("Designing", "Denise");
        Task task3 = Task.create("Documentation", "Jacky");
        Employee employee1 = Employee.create("Diana", "IT",
                Arrays.asList("111-111-111", "222-222-222"), Arrays.asList(task1, task2));
        Employee employee2 = Employee.create("Rose", "Sales",
                Arrays.asList("444-444-444", "333-333-333"), Arrays.asList(task3, task1));
        Employee employee3 = Employee.create("Denise", "Admin",
                Arrays.asList("444-444-444", "555-555-555"), Arrays.asList(task2, task3));
        Employee employee4 = Employee.create("Mike", "HR",
                Arrays.asList("666-666-666", "777-777-777"), Arrays.asList(task1));
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.getTransaction().commit();
        em.close();
    }

    private static void findAllEmployees() {
        System.out.println("-- All employees --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT e FROM Employee e");
        List<Employee> employees = query.getResultList();
        for (Employee employee : employees) {
            System.out.println("-------------------------------------------");
            System.out.println("employee: " + employee);
            System.out.println("phones: " + employee.getPhones());
            System.out.println("tasks: " + employee.getTasks());
        }
        em.close();
    }

    private static void findEmployeeByPhone() {
        System.out.println("\n-- Employees with phone 111-111-111 --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT e FROM Employee e JOIN e.phones p WHERE p='111-111-111'");
        List<Employee> employees = query.getResultList();
        printEmployeesWithPhones(employees);
        em.close();
    }

    private static void findEmployeeByPhones() {
        System.out.println("\n-- Employees with phone 333-333-333 or 444-444-444 --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT DISTINCT e FROM Employee e JOIN e.phones p WHERE p IN "
                        + "('333-333-333', '444-444-444')");
        List<Employee> employees = query.getResultList();
        printEmployeesWithPhones(employees);
        em.close();
    }

    private static void findEmployeeByPhones2() {
        System.out.println("\n-- Employees with phones 333-333-333 and 444-444-444 --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT DISTINCT e FROM Employee e WHERE "
                        + " '333-333-333' MEMBER OF e.phones AND '444-444-444' MEMBER OF e.phones");
        List<Employee> employees = query.getResultList();
        printEmployeesWithPhones(employees);
        em.close();
    }

    private static void findEmployeeByTask() {
        System.out.println("\n-- Employees with tasks Designing --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT DISTINCT e FROM Employee e JOIN e.tasks t WHERE t.name='Designing'");
        List<Employee> employees = query.getResultList();
        printEmployeesWithTasks(employees);
        em.close();
    }

    private static void findEmployeeByTasks() {
        System.out.println("\n-- Employees with tasks 'Documentation' or 'Designing' --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery(
                "SELECT DISTINCT e FROM Employee e JOIN e.tasks t WHERE t.name "
                        + " IN ('Documentation', 'Designing')");
        List<Employee> employees = query.getResultList();
        printEmployeesWithTasks(employees);
        em.close();
    }

    private static void findEmployeeByTasks2() {
        System.out.println("\n-- Employees with tasks 'Documentation' AND 'Designing' --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Task documentationTask =
                (Task) em.createQuery("SELECT t FROM Task t WHERE t.name= 'Documentation'").getSingleResult();
        Task designingTask =
                (Task) em.createQuery("SELECT t FROM Task t WHERE t.name= 'Designing'").getSingleResult();
        Query query = em.createQuery(
                "SELECT  e FROM Employee e WHERE "
                        + " :docTask MEMBER OF e.tasks AND :designTask MEMBER OF e.tasks");
        query.setParameter("docTask", documentationTask);
        query.setParameter("designTask", designingTask);
        List<Employee> employees = query.getResultList();
        printEmployeesWithTasks(employees);
        em.close();
    }

    private static void printEmployeesWithPhones(List<Employee> employees) {
        for (Employee employee : employees) {
            System.out.println("-------------------------------------------");
            System.out.println("employee: " + employee);
            System.out.println("phones: " + employee.getPhones());
        }
    }

    private static void printEmployeesWithTasks(List<Employee> employees) {
        for (Employee employee : employees) {
            System.out.println("-------------------------------------------");
            System.out.println("employee: " + employee);
            System.out.println("tasks: " + employee.getTasks());
        }
    }
}