package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findAllEmployees();
        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 2000, "IT");
        Employee employee2 = Employee.create("Rose", 3500, "Admin");
        Employee employee3 = Employee.create("Denise", 2500, "Admin");
        Employee employee4 = Employee.create("Mike", 4000, "IT");
        Employee employee5 = Employee.create("Linda", 4500, "Sales");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.persist(employee5);
        em.getTransaction().commit();
        em.close();
    }

    private static void findAllEmployees() {
        EntityManager em = entityManagerFactory.createEntityManager();
        System.out.println("-- All employees --");
        Query query = em.createQuery(
                "SELECT e.name, e.salary, "
                        + "CASE e.dept "
                        + "WHEN 'IT' THEN 'Information Technology' "
                        + "WHEN 'Admin' THEN 'Administration' "
                        + " ELSE e.dept "
                        + "END "
                        + "FROM Employee e");
        List<Object[]> resultList = query.getResultList();
        resultList.forEach(o -> System.out.println(Arrays.toString(o)));
        em.close();
    }
}