package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.util.Arrays;
import java.util.List;

public class Util {

    public static void runExampleFor(String persistenceUnit, Class<?> entity) throws Exception{
        EntityManagerFactory emf = Persistence.createEntityManagerFactory(persistenceUnit);
        EntityManager em = emf.createEntityManager();

        nativeQuery(em, "SHOW TABLES");
        nativeQuery(em, "SELECT * FROM INFORMATION_SCHEMA.SEQUENCES");
        nativeQuery(em, "SHOW COLUMNS from "+ entity.getSimpleName());

        Object entity1 = entity.newInstance();
        Object entity2 = entity.newInstance();
        em.getTransaction().begin();
        em.persist(entity1);
        em.persist(entity2);
       em.getTransaction().commit();

        nativeQuery(em, "SELECT * FROM "+entity.getSimpleName());

        em.close();
        emf.close();
    }

    private static void nativeQuery(EntityManager entityManager, String s) {
        System.out.println("--------\n" + s);
        Query query = entityManager.createNativeQuery(s);
        List list = query.getResultList();
        for (Object o : list) {
            if (o instanceof Object[]) {
                System.out.println(Arrays.toString((Object[]) o));
            } else {
                System.out.println(o);
            }
        }
    }
}