package com.logicbig.example;

import javax.persistence.*;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class ExampleMain {
    private static EntityManagerFactory emf;

    public static void main(String[] args) {
        emf = Persistence.createEntityManagerFactory("example-unit");
        try {
            nativeQuery("SHOW COLUMNS from person");
            persistPersons();
            nativeQuery("Select * from person");
            runGroupByQuery();
        } finally {
            emf.close();
        }
    }

    private static void persistPersons() {
        System.out.println("-- persisting persons --");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();

        List<String> deptList = Arrays.asList("Admin", "IT", "Sell");
        for (int i = 1; i <= 20; i++) {
            Person p = new Person();
            p.setName("Person name " + i);
            //set dept randomly
            int index = ThreadLocalRandom.current()
                                         .nextInt(0, 3);
            p.setDept(deptList.get(index));
            em.persist(p);
        }
        em.getTransaction().commit();
        em.close();
        System.out.println("-- persisting persons finished --");
    }

    private static void runGroupByQuery() {
        System.out.println("-- running group by criteria query --");
        System.out.println("-- dept groups having count more than 5 --");
        EntityManager em = emf.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery<DeptGroup> criteriaQuery = cb.createQuery(DeptGroup.class);
        Root<Person> root = criteriaQuery.from(Person.class);

        Expression<String> groupByExp = root.get("dept").as(String.class);
        Expression<Long> countExp = cb.count(groupByExp);
        CriteriaQuery<DeptGroup> select =
                criteriaQuery.multiselect(groupByExp, countExp);
        criteriaQuery.groupBy(groupByExp);
        criteriaQuery.having(cb.gt(cb.count(root), 5));
        //ordering by count in descending order
        criteriaQuery.orderBy(cb.desc(countExp));

        TypedQuery<DeptGroup> query = em.createQuery(select);
        List<DeptGroup> resultList = query.getResultList();
        resultList.forEach(System.out::println);
    }

    public static void nativeQuery(String s) {
        System.out.printf("'%s'%n", s);
        EntityManager em = emf.createEntityManager();
        Query query = em.createNativeQuery(s);
        List list = query.getResultList();
        for (Object o : list) {
            if (o instanceof Object[]) {
                System.out.println(Arrays.toString((Object[]) o));
            } else {
                System.out.println(o);
            }
        }
        em.close();
    }
}