package com.logicbig.example;

import javax.persistence.*;
import java.util.Arrays;
import java.util.List;

public class ExampleMain2 {

    public static void main(String[] args) {
        EntityManagerFactory emf =
                Persistence.createEntityManagerFactory("example-unit");
        try {
            persistEntity(emf);
        } finally {
            emf.close();
        }
    }

    private static void persistEntity(EntityManagerFactory emf) {
        EntityManager em = emf.createEntityManager();
        em.setFlushMode(FlushModeType.COMMIT);
        List<Employee> employeeList = getNewEmployees();

        em.getTransaction().begin();
        for (Employee employee : employeeList) {
            em.persist(employee);
        }
        // em.flush();
        showPersistedITEmployees(em);
        em.getTransaction().commit();
        em.close();
    }


    private static void showPersistedITEmployees(EntityManager em) {
        Query query =
                em.createQuery("Select e from Employee e where e.department ='IT'");
        System.out.println("-- IT employees persisted list --");
        List<Employee> list = (List<Employee>) query.getResultList();
        list.forEach(System.out::println);
    }

    public static List<Employee> getNewEmployees() {
        return Arrays.asList(new Employee("Sara Dorsey", "Admin"),
                new Employee("Mike Volin", "IT"));
    }
}