package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NotThreadSafeExample {

    public static void main(String[] args) {
        final EntityManagerFactory emf = Persistence.createEntityManagerFactory("testPersistenceUnit");
        final EntityManager em = emf.createEntityManager();
        ExecutorService es = Executors.newFixedThreadPool(2);

        List<Future<?>> futures = new ArrayList<>();
        Future<?> f1 = es.submit(() -> {
            return runTask(em, 1, "test 1");

        });
        Future<?> f2 = es.submit(() -> {
            return runTask(em, 2, "test 2");
        });
        futures.add(f1);
        futures.add(f2);
        try {//waiting for threads to finish
            for (Future<?> future : futures) {
                future.get();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        nativeQuery(em, "Select * from MyEntity");
        es.shutdown();
        em.close();
        emf.close();
    }

    private static String runTask(EntityManager em, int id, String str) {
        System.out.printf("persisting id: %s str:%s%n", id, str);
        em.getTransaction().begin();
        em.persist(createNewMyEntity(id, str));
        em.getTransaction().commit();
        return "done executing id: " + id;
    }

    private static MyEntity createNewMyEntity(int id, String str) {
        MyEntity entity = new MyEntity();
        entity.setMyId(id);
        entity.setMyStr(str);
        return entity;
    }

    private static void nativeQuery(EntityManager entityManager, String s) {
        System.out.println("--------\n" + s);
        Query query = entityManager.createNativeQuery(s);
        List list = query.getResultList();
        for (Object o : list) {
            System.out.println(Arrays.toString((Object[]) o));
        }
    }
}