package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistArticle();
            updateArticle();
            updatePublisher();
            loadArticles();
        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistArticle() {
        System.out.println("-- persisting --");
        Article article = new Article();
        article.setContent("some test content");
        article.setPublisher(new Publisher("Adam"));
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(article);
        em.getTransaction().commit();
        em.close();
        System.out.println("Article persisted: " + article);
        System.out.println("Related Publisher: " + article.getPublisher());
    }

    public static void updateArticle() {
        System.out.println("-- loading and updating Article --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Article article = em.find(Article.class, 1);
        em.getTransaction().begin();
        article.setContent("new updated content");
        em.getTransaction().commit();
        em.close();
        System.out.println("Article updated: " + article);
        System.out.println("Related Publisher: " + article.getPublisher());
    }

    public static void updatePublisher() {
        System.out.println("-- loading and updating Publisher --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Publisher publisher = em.find(Publisher.class, 2);
        em.getTransaction().begin();
        publisher.setName("Jerry");
        em.getTransaction().commit();
        em.close();
        System.out.println("Publisher updated: " + publisher);
    }

    private static void loadArticles() {
        System.out.println("-- loading --");
        EntityManager em = entityManagerFactory.createEntityManager();
        Query query = em.createQuery("SELECT t FROM Article t");
        List<Article> resultList = query.getResultList();
        for (Article article : resultList) {
            System.out.println(article);
            System.out.println(article.getPublisher());
        }
    }
}