package com.logicbig.example;

import javax.persistence.*;
import java.sql.Timestamp;

@Entity
@EntityListeners(AuditableListener.class)
public class Article implements Auditable {
    @Id
    @GeneratedValue
    private int id;
    private String content;
    @ManyToOne(cascade = CascadeType.ALL)
    private Publisher publisher;
    private Timestamp dateCreated;
    private Timestamp lastUpdated;

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Publisher getPublisher() {
        return publisher;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public Timestamp getDateCreated() {
        return dateCreated;
    }

    @Override
    public void setDateCreated(Timestamp dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public Timestamp getLastUpdated() {
        return lastUpdated;
    }

    @Override
    public void setLastUpdated(Timestamp lastUpdated) {
        this.lastUpdated = lastUpdated;
    }


    @Override
    public String toString() {
        return "Article{" +
                "id=" + id +
                ", content='" + content + '\'' +
                ", dateCreated=" + dateCreated +
                ", lastUpdated=" + lastUpdated +
                '}';
    }
}