package com.logicbig.example;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import java.io.File;

@Converter
public class FileConverter implements AttributeConverter<File, String> {

    @Override
    public String convertToDatabaseColumn(File attribute) {
        return attribute.getAbsolutePath();
    }

    @Override
    public File convertToEntityAttribute(String dbData) {
        return new File(dbData);
    }
}