package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            nativeQuery("Show Columns from Report");
            persistEntity();
            nativeQuery("Select * from Report");
            findEntity();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEntity() {
        EntityManager em = entityManagerFactory.createEntityManager();
        Report report = em.find(Report.class, 1L);
        System.out.println("Report loaded: " + report);
        em.close();
    }


    public static void persistEntity() {
        Report report = new Report();
        report.setDescription("test report");
        report.setFile(new File("c:/temp/report-details.txt"));
        System.out.println("Persisting report: " + report);
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(report);
        em.getTransaction().commit();
        em.close();
    }

    public static void nativeQuery(String s) {
        EntityManager em = entityManagerFactory.createEntityManager();
        System.out.printf("'%s'%n", s);
        Query query = em.createNativeQuery(s);
        List list = query.getResultList();
        for (Object o : list) {
            if (o instanceof Object[]) {
                System.out.println(Arrays.toString((Object[]) o));
            } else {
                System.out.println(o);
            }
        }
        em.close();
    }
}