package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import java.util.Date;
import java.util.List;

public class ExampleMain2 {

    public static void main(String[] args) throws Exception {
        EntityManagerFactory emf =
                Persistence.createEntityManagerFactory("example-unit");
        try {
            persistEntity(emf);
            runNativeQuery(emf);
            findEntityById(emf);
        } finally {
            emf.close();
        }
    }

    private static void persistEntity(EntityManagerFactory emf) throws Exception {
        System.out.println("-- Persisting entity --");
        EntityManager em = emf.createEntityManager();

        Employee e = new Employee(1L, "Mike", "IT");
        CompositeTaskId cti = new CompositeTaskId(1L, 100L);
        Task task = new Task(cti, e);
        task.setTaskName("coding");
        task.setDate(new Date());

        em.getTransaction().begin();
        em.persist(e);
        em.persist(task);
        em.getTransaction().commit();
        em.close();
    }

    private static void runNativeQuery(EntityManagerFactory emf) {
        System.out.println("-- Native query --");
        EntityManager em = emf.createEntityManager();
        ExampleMain.nativeQuery(em, "Select * from EMPLOYEE");
        ExampleMain.nativeQuery(em, "Select * from Task");
    }

    private static void findEntityById(EntityManagerFactory emf) {
        System.out.println("-- Finding entity --");
        EntityManager em = emf.createEntityManager();
        CompositeTaskId taskId = new CompositeTaskId(1, 100);
        Task task = em.find(Task.class, taskId);
        System.out.println(task);
        em.close();
    }
}