package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class ExampleMain {

    static EntityManagerFactory emf =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) throws Exception {
        try {
            long id = persistPerson();
            Person person = loadPersonById(id);
            person.getPhoneList().forEach(System.out::println);
        } finally {
            emf.close();
        }
    }

    private static Person loadPersonById(long id) {
        EntityManager em = emf.createEntityManager();
        Person person = em.find(Person.class, id);
        em.close();
        return person;
    }


    private static long persistPerson() {
        Person person = new Person();
        person.setName("Jackie");
        person.addPhone("111-11-1111", "cell");
        person.addPhone("22-222-2222", "work");

        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.persist(person);
        em.getTransaction().commit();
        em.close();
        return person.getId();
    }
}