package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.persistence.criteria.*;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findAllEmployees();
            updateITEmployeesSalaries();
            findAllEmployees();
            updateAllEmployeesSalaries();
            findAllEmployees();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void updateITEmployeesSalaries() {
        System.out.println("-- increasing IT employees salaries by 500 --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaUpdate<Employee> criteriaUpdate = criteriaBuilder.createCriteriaUpdate(Employee.class);
        Root<Employee> employeeRoot = criteriaUpdate.from(Employee.class);
        criteriaUpdate.set(employeeRoot.get(Employee_.salary),
                criteriaBuilder.sum(employeeRoot.get(Employee_.salary), 500d))
                      .where(criteriaBuilder.equal(employeeRoot.get(Employee_.DEPT), "IT"));
        //the equivalent JPQL
        //UPDATE Employee e SET e.salary = e.salary + 500 WHERE e.dept = 'IT'
        entityManager.getTransaction().begin();
        int i = entityManager.createQuery(criteriaUpdate).executeUpdate();
        System.out.println("Entities updated: " + i);
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    private static void updateAllEmployeesSalaries() {
        System.out.println("-- increasing all employees salaries by different percentage --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaUpdate<Employee> criteriaUpdate = criteriaBuilder.createCriteriaUpdate(Employee.class);
        Root<Employee> root = criteriaUpdate.from(Employee.class);

        CriteriaBuilder.SimpleCase<String, Double> deptCase =
                criteriaBuilder.selectCase(root.get(Employee_.DEPT));
        Expression<Double> caseExpression =
                deptCase.when("IT", criteriaBuilder.prod(root.get(Employee_.SALARY), 1.20))
                        .when("Admin", criteriaBuilder.prod(root.get(Employee_.SALARY), 1.15))
                        .otherwise(criteriaBuilder
                                .prod(root.get(Employee_.SALARY), 1.12));
        criteriaUpdate.set(root.get(Employee_.salary), caseExpression);
        //the equivalent JPQL
        /*UPDATE Employee e SET e.salary =
                 CASE
                  WHEN e.dept = 'IT' THEN (e.salary * 1.20)
                  WHEN e.dept = 'Admin' THEN (e.salary * 1.15)
                  ELSE (e.salary * 1.12)
                  END*/

        entityManager.getTransaction().begin();
        int rowsUpdated = entityManager.createQuery(criteriaUpdate).executeUpdate();
        System.out.println("entities Updated: " + rowsUpdated);
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 2000, "IT");
        Employee employee2 = Employee.create("Rose", 3500, "Admin");
        Employee employee3 = Employee.create("Denise", 2500, "Admin");
        Employee employee4 = Employee.create("Mike", 4000, "IT");
        Employee employee5 = Employee.create("Linda", 4500, "Sales");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.persist(employee5);
        em.getTransaction().commit();
        em.close();
    }

    private static void findAllEmployees() {
        EntityManager em = entityManagerFactory.createEntityManager();
        System.out.println("-- All employees --");
        Query query = em.createQuery(
                "SELECT e FROM Employee e");
        List<Employee> resultList = query.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }
}