package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findAllEmployees();
            deleteEmployeeByName();
            findAllEmployees();
            deleteAllEmployees();
            findAllEmployees();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void deleteEmployeeByName() {
        System.out.println("-- delete employee by name 'Mike' --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaDelete<Employee> criteriaDelete = criteriaBuilder.createCriteriaDelete(Employee.class);
        Root<Employee> root = criteriaDelete.from(Employee.class);
        criteriaDelete.where(criteriaBuilder.equal(root.get(Employee_.name), "Mike"));
        //The equivalent JPQL: DELETE FROM Employee e WHERE e.name = 'Mike'
        entityManager.getTransaction().begin();
        int rowsDeleted = entityManager.createQuery(criteriaDelete).executeUpdate();
        System.out.println("entities deleted: " + rowsDeleted);
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    private static void deleteAllEmployees() {
        System.out.println("-- delete all employees --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaDelete<Employee> criteriaDelete = criteriaBuilder.createCriteriaDelete(Employee.class);
        criteriaDelete.from(Employee.class);
        //The equivalent JPQL: DELETE FROM Employee e
        entityManager.getTransaction().begin();
        int rowsDeleted = entityManager.createQuery(criteriaDelete).executeUpdate();
        System.out.println("entities deleted: " + rowsDeleted);
        entityManager.getTransaction().commit();
        entityManager.close();
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 2000, "IT");
        Employee employee2 = Employee.create("Rose", 3500, "Admin");
        Employee employee3 = Employee.create("Denise", 2500, "Admin");
        Employee employee4 = Employee.create("Mike", 4000, "IT");
        Employee employee5 = Employee.create("Linda", 4500, "Sales");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.persist(employee5);
        em.getTransaction().commit();
        em.close();
    }

    private static void findAllEmployees() {
        System.out.println("-- All employees --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Employee> criteriaQuery = criteriaBuilder.createQuery(Employee.class);
        criteriaQuery.from(Employee.class);
        List<Employee> resultList = entityManager.createQuery(criteriaQuery).getResultList();
        System.out.println("Employees count: " + resultList.size());
        resultList.forEach(System.out::println);
        entityManager.close();
    }
}