package com.logicbig.example;

import javax.persistence.*;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findAllEmployeeEntities();
            findEmployeeInfo();
            findEmployeeInfo2();
            findEmployeeInfo3();
        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 2000, "IT");
        Employee employee2 = Employee.create("Rose", 4500, "Admin");
        Employee employee3 = Employee.create("Denise", 2000, "Admin");
        Employee employee4 = Employee.create("Mike", 4000, "IT");
        Employee employee5 = Employee.create("Linda", 4500, "Sales");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.persist(employee5);
        em.getTransaction().commit();
        em.close();
    }

    private static void findAllEmployeeEntities() {
        System.out.println("-- finding Employee entities - entity selection --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery<Employee> query = cb.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee);
        TypedQuery<Employee> typedQuery = em.createQuery(query);
        List<Employee> resultList = typedQuery.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    private static void findEmployeeInfo() {
        System.out.println("-- Employee name and salaries using Tuple --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery<Tuple> query = cb.createTupleQuery();
        Root<Employee> employee = query.from(Employee.class);
        query.select(cb.tuple(employee.get(Employee_.name),
                employee.get(Employee_.salary)));
        TypedQuery<Tuple> typedQuery = em.createQuery(query);
        List<Tuple> resultList = typedQuery.getResultList();
        resultList.forEach(tuple -> {
            System.out.printf("Name: %s, Salary: %s%n",
                    tuple.get(0, String.class), tuple.get(1, Double.class));
        });
        em.close();
    }

    private static void findEmployeeInfo2() {
        System.out.println("-- Employee name and salaries using multiselect --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery<Tuple> query = cb.createTupleQuery();
        Root<Employee> employee = query.from(Employee.class);
        query.multiselect(employee.get(Employee_.name), employee.get(Employee_.salary));
        TypedQuery<Tuple> typedQuery = em.createQuery(query);
        List<Tuple> resultList = typedQuery.getResultList();
        resultList.forEach(tuple -> {
            System.out.printf("Name: %s, Salary: %s%n",
                    tuple.get(0, String.class), tuple.get(1, Double.class));
        });
        em.close();
    }

    private static void findEmployeeInfo3() {
        System.out.println("-- Employee name and salaries using createQuery(Tuple.class) --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery<Tuple> query = cb.createQuery(Tuple.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(cb.tuple(employee.get(Employee_.name),
                employee.get(Employee_.salary)));
        TypedQuery<Tuple> typedQuery = em.createQuery(query);
        List<Tuple> resultList = typedQuery.getResultList();
        resultList.forEach(tuple -> {
            System.out.printf("Name: %s, Salary: %s%n",
                    tuple.get(0, String.class), tuple.get(1, Double.class));
        });
        em.close();
    }
}