package com.logicbig.example;

import javax.persistence.*;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployeeByNullDept();
            findEmployeeByDeptNoNull();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEmployeeByNullDept() {
        System.out.println("-- Employees with dept = NULL --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee)
             .where(employee.get(Employee_.dept).isNull());
        TypedQuery<Employee> typedQuery = em.createQuery(query);
        List<Employee> resultList = typedQuery.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    private static void findEmployeeByDeptNoNull() {
        System.out.println("-- Employees with dept not NULL --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee)
             .where(employee.get(Employee_.dept).isNotNull());
        TypedQuery<Employee> typedQuery = em.createQuery(query);
        List<Employee> resultList = typedQuery.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", "IT", 3000);
        Employee employee2 = Employee.create("Rose", "Sales", 2500);
        Employee employee3 = Employee.create("Denise", "Admin", 4000);
        Employee employee4 = Employee.create("Mike", null, 3500);
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.getTransaction().commit();
        em.close();
        System.out.println("-- employees persisted --");
        System.out.println(employee1);
        System.out.println(employee2);
        System.out.println(employee3);
        System.out.println(employee4);
    }
}