package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            //using like
            findEmployeeBySalary();
            findEmployeeByName();
            //using not like
            findEmployeeByName2();
            //using like with escaping
            findEmployeeByDept();
        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", "IT", 3000);
        Employee employee2 = Employee.create("Rose", "Sales", 2500);
        Employee employee3 = Employee.create("Denise", "Admin", 4000);
        Employee employee4 = Employee.create("Mike", "H_R", 3500);
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.getTransaction().commit();
        em.close();
        System.out.println("-- employees persisted --");
        System.out.println(employee1);
        System.out.println(employee2);
        System.out.println(employee3);
        System.out.println(employee4);
    }

    private static void findEmployeeBySalary() {
        System.out.println("-- Employees with salary LIKE _500 --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee)
             .where(criteriaBuilder.like(
                     employee.get(Employee_.salary).as(String.class), "_500" ));
        entityManager.createQuery(query).getResultList().forEach(System.out::println);
        entityManager.close();
    }

    private static void findEmployeeByName() {
        System.out.println("-- Employees name LIKE D% --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee)
             .where(criteriaBuilder.like(employee.get(Employee_.name),"D%"));
        entityManager.createQuery(query).getResultList().forEach(System.out::println);
        entityManager.close();

    }

    private static void findEmployeeByName2() {
        System.out.println("-- Employees name NOT LIKE D% --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee)
             .where(criteriaBuilder.notLike(employee.get(Employee_.name),"D%"));
        entityManager.createQuery(query).getResultList().forEach(System.out::println);
        entityManager.close();
    }

    private static void findEmployeeByDept() {
        System.out.println("-- Employees dept LIKE '%@_%' ESCAPE '@' --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee)
             .where(criteriaBuilder.like(employee.get(Employee_.dept), "%@_%", '@'));
        entityManager.createQuery(query).getResultList().forEach(System.out::println);
        entityManager.close();
    }
}