package com.logicbig.example;

import javax.persistence.*;
import java.util.Arrays;
import java.util.List;

@Entity
public class Employee {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    @ManyToMany(cascade = CascadeType.ALL)
    private List<Task> tasks;
    @ElementCollection
    private List<String> phoneNumbers;
    private String primaryPhoneNumber;

    public String getName() {
        return name;
    }

    public List<Task> getTasks() {
        return tasks;
    }

    public List<String> getPhoneNumbers() {
        return phoneNumbers;
    }

    public void setPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public static Employee create(String name, List<String> phoneNumbers,
                                  String primaryPhoneNumber, Task... tasks) {
        Employee e = new Employee();
        e.name = name;
        if (tasks != null) {
            e.tasks = Arrays.asList(tasks);
        }
        e.phoneNumbers = phoneNumbers;
        e.primaryPhoneNumber = primaryPhoneNumber;
        return e;
    }

    @Override
    public String toString() {
        return "Employee{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", tasks=" + tasks +
                ", phoneNumbers=" + phoneNumbers +
                ", primaryPhoneNumber='" + primaryPhoneNumber + '\'' +
                '}';
    }
}