package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Root;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployeeWithNoTask();
            findEmployeeWithTasks();
            findEmployeeWithNoTaskSupervisor();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEmployeeWithNoTask() {
        System.out.println("-- Employees with no tasks --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<Employee> criteriaQuery = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = criteriaQuery.from(Employee.class);
        criteriaQuery.select(employee)
                     .where(criteriaBuilder.isEmpty(employee.get(Employee_.tasks)));
        TypedQuery<Employee> typedQuery = em.createQuery(criteriaQuery);
        typedQuery.getResultList().forEach(System.out::println);
        em.close();
    }

    private static void findEmployeeWithTasks() {
        System.out.println("-- Employees with tasks --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<Employee> criteriaQuery = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = criteriaQuery.from(Employee.class);
        criteriaQuery.select(employee)
                     .where(criteriaBuilder.isNotEmpty(employee.get(Employee_.tasks)));
        TypedQuery<Employee> typedQuery = em.createQuery(criteriaQuery);
        typedQuery.getResultList().forEach(System.out::println);
        em.close();
   }

    private static void findEmployeeWithNoTaskSupervisor() {
        System.out.println("-- Employees with no task supervisor --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<Employee> criteriaQuery = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = criteriaQuery.from(Employee.class);
        ListJoin<Employee, Task> tasks = employee.join(Employee_.tasks);
        criteriaQuery.select(employee)
                     .distinct(true)
                     .where(criteriaBuilder.isNull(tasks.get(Task_.supervisor)));
        TypedQuery<Employee> typedQuery = em.createQuery(criteriaQuery);
        typedQuery.getResultList().forEach(System.out::println);
        em.close();
    }

    public static void persistEmployees() {
        Task task1 = new Task("Coding", "Denise");
        Task task2 = new Task("Refactoring", "Rose");
        Task task3 = new Task("Designing", "Denise");
        Task task4 = new Task("Documentation", null);

        Employee employee1 = Employee.create("Diana", task1, task3);
        Employee employee2 = Employee.create("Mike");
        Employee employee3 = Employee.create("Tim", task2, task4);
        Employee employee4 = Employee.create("Jack");

        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.getTransaction().commit();
        em.close();
        System.out.println("-- Employee persisted --");
        System.out.println(employee1);
        System.out.println(employee2);
        System.out.println(employee3);
        System.out.println(employee4);
    }
}