package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployeeBySalary();
            findEmployeeByName();
            findEmployeeByDept();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEmployeeBySalary() {
        System.out.println("-- Employees with salary IN 2000, 3000 and 4000 --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee)
             .where(employee.get(Employee_.salary).in(2000, 3000, 4000));
        TypedQuery<Employee> typedQuery = em.createQuery(query);
        List<Employee> resultList = typedQuery.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    //negating IN predicate
    private static void findEmployeeByName() {
        System.out.println("-- Employees name NOT IN Diana and Rose --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee)
             .where(employee.get(Employee_.name).in("Diana", "Rose").not());
        TypedQuery<Employee> typedQuery = em.createQuery(query);
        List<Employee> resultList = typedQuery.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    //using  Predicate in(Expression<?>... values);
    private static void findEmployeeByDept() {
        System.out.println("-- Employees dept IN IT, Sales and HR --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<Employee> query = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = query.from(Employee.class);
        ParameterExpression<Collection> deptParamExpression = criteriaBuilder.parameter(Collection.class);
        query.select(employee)
             .where(employee.get(Employee_.dept).in(deptParamExpression));
        TypedQuery<Employee> typedQuery = em.createQuery(query);
        typedQuery.setParameter(deptParamExpression, Arrays.asList("IT", "Sales", "HR"));
        List<Employee> resultList = typedQuery.getResultList();
        resultList.forEach(System.out::println);
        em.close();
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", "IT", 3000);
        Employee employee2 = Employee.create("Rose", "Sales", 2000);
        Employee employee3 = Employee.create("Denise", "Admin", 4000);
        Employee employee4 = Employee.create("Mike", "HR", 3500);
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.getTransaction().commit();
        em.close();
        System.out.println("-- employees persisted --");
        System.out.println(employee1);
        System.out.println(employee2);
        System.out.println(employee3);
        System.out.println(employee4);
    }
}