package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import java.util.ArrayList;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEntities();
            findEmployeeIfJobInfoExists();
            findEmployeesIfJobInfoNotExists();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEmployeeIfJobInfoExists() {
        System.out.println("-- executing EXISTS query --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();

        //main query
        CriteriaQuery<Employee> employeeQuery = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = employeeQuery.from(Employee.class);
        //subquery
        Subquery<JobInfo> jobInfoSubquery = employeeQuery.subquery(JobInfo.class);
        Root<JobInfo> jobInfo = jobInfoSubquery.from(JobInfo.class);
        jobInfoSubquery.select(jobInfo)//subquery selection
                       .where(criteriaBuilder.equal(jobInfo.get(JobInfo_.jobName),
                               employee.get(Employee_.job)));//subquery restriction
        //main query selection
        employeeQuery.select(employee)
                     .where(criteriaBuilder.exists(jobInfoSubquery));

        TypedQuery<Employee> typedQuery = entityManager.createQuery(employeeQuery);
        List<Employee> resultList = typedQuery.getResultList();
        resultList.forEach(System.out::println);

        entityManager.close();
        // equivalent JPQL
        //"SELECT e FROM Employee e WHERE EXISTS (SELECT j from JobInfo j WHERE j.jobName = e.job)"
    }

    private static void findEmployeesIfJobInfoNotExists() {
        System.out.println("-- executing  NOT EXISTS query --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        //main query
        CriteriaQuery<Employee> employeeQuery = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = employeeQuery.from(Employee.class);
        //subquery
        Subquery<JobInfo> jobInfoSubquery = employeeQuery.subquery(JobInfo.class);
        Root<JobInfo> jobInfo = jobInfoSubquery.from(JobInfo.class);
        jobInfoSubquery.select(jobInfo)
                       .where(criteriaBuilder.equal(jobInfo.get(JobInfo_.jobName),
                               employee.get(Employee_.job)));
        //main query selection
        employeeQuery.select(employee)
                     .where(criteriaBuilder.not(criteriaBuilder.exists(jobInfoSubquery)));

        TypedQuery<Employee> typedQuery = entityManager.createQuery(employeeQuery);
        List<Employee> resultList = typedQuery.getResultList();
        resultList.forEach(System.out::println);
        entityManager.close();
        ///equivalent JPQL
        // "SELECT e FROM Employee e WHERE NOT EXISTS(SELECT j from JobInfo j WHERE j.jobName = e.job)"
    }

    public static void persistEntities() {
        System.out.println("-- persisting entities --");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        List<Employee> employees = getEmployees();
        employees.forEach(em::persist);
        List<JobInfo> jobInfoList = getJobInfoList();
        jobInfoList.forEach(em::persist);
        em.getTransaction().commit();
        em.close();
        employees.forEach(System.out::println);
        jobInfoList.forEach(System.out::println);
    }

    private static List<Employee> getEmployees() {
        List<Employee> employees = new ArrayList<>();
        employees.add(Employee.create("Diana", "Developer"));
        employees.add(Employee.create("Mike", "Manager"));
        employees.add(Employee.create("Tim", "Salesman"));
        employees.add(Employee.create("Jack", "Architect"));
        return employees;
    }

    private static List<JobInfo> getJobInfoList() {
        List<JobInfo> list = new ArrayList<>();
        list.add(JobInfo.create("Developer", "Consultant"));
        list.add(JobInfo.create("Manager", "FullTime"));
        list.add(JobInfo.create("Architect", "Consultant"));
        return list;
    }
}