package com.logicbig.example;

import javax.persistence.*;
import java.util.Arrays;
import java.util.List;

@Entity
public class Project {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    @OneToMany(cascade = CascadeType.ALL)
    private List<Employee> employees;
    @OneToOne(cascade = CascadeType.ALL)
    private Employee supervisor;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Employee> getEmployees() {
        return employees;
    }

    public void setEmployees(List<Employee> employees) {
        this.employees = employees;
    }

    public Employee getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(Employee supervisor) {
        this.supervisor = supervisor;
    }

    public static Project create(Employee supervisor, String projectName,  Employee... employees) {
        Project p = new Project();
        p.setName(projectName);
        p.setEmployees(Arrays.asList(employees));
        p.setSupervisor(supervisor);
        return p;
    }

    @Override
    public String toString() {
        return "Project{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", supervisor= "+supervisor +
                ", employees=" + employees +
                '}';
    }
}