package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findDistinctDepts();
            findDistinctSalaries();
            findDistinctDeptAndSalaries();
        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 2000, "IT");
        Employee employee2 = Employee.create("Rose", 4500, "Admin");
        Employee employee3 = Employee.create("Denise", 2000, "Admin");
        Employee employee4 = Employee.create("Mike", 4000, "IT");
        Employee employee5 = Employee.create("Linda", 4500, "Sales");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.persist(employee5);
        em.getTransaction().commit();
        System.out.println("-- employee persisted --");
        CriteriaQuery<Employee> query = em.getCriteriaBuilder()
                                          .createQuery(Employee.class);
        query.select(query.from(Employee.class));
        em.createQuery(query).getResultList().forEach(System.out::println);
        em.close();
    }

    private static void findDistinctDepts() {
        System.out.println("-- Distinct dept --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaQuery<String> query = em.getCriteriaBuilder()
                                        .createQuery(String.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee.get(Employee_.dept))
             .distinct(true);
        TypedQuery<String> tq = em.createQuery(query);
        List<String> resultList = tq.getResultList();
        resultList.forEach(System.out::println);
    }

    private static void findDistinctSalaries() {
        System.out.println("-- Distinct salaries order by salary desc --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery<Double> query = cb.createQuery(Double.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(employee.get(Employee_.salary))
             .orderBy(cb.desc(employee.get(Employee_.salary)))
             .distinct(true);
        TypedQuery<Double> tq = em.createQuery(query);
        List<Double> resultList = tq.getResultList();
        resultList.forEach(System.out::println);
    }

    private static void findDistinctDeptAndSalaries() {
        System.out.println("-- Distinct dept and salaries order by dept asc and salary desc --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery<Object[]> query = cb.createQuery(Object[].class);
        Root<Employee> employee = query.from(Employee.class);
        query.multiselect(employee.get(Employee_.dept), employee.get(Employee_.salary))
             .orderBy(cb.asc(employee.get(Employee_.dept)), cb.desc(employee.get(Employee_.salary)))
             .distinct(true);
        TypedQuery<Object[]> tq = em.createQuery(query);
        List<Object[]> resultList = tq.getResultList();
        resultList.forEach(arr -> System.out.println(Arrays.toString(arr)));
    }
}