package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.*;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployeeByPhoneCount();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEmployeeByPhoneCount() {
        System.out.println("-- Employees who have more than 2 phones inclusively --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        //main query
        CriteriaQuery<Employee> employeeQuery = criteriaBuilder.createQuery(Employee.class);
        Root<Employee> employee = employeeQuery.from(Employee.class);

        //phone count subquery
        Subquery<Long> countSubQuery = employeeQuery.subquery(Long.class);

        //create the subquery root correlated to the parent subquery root
        Root<Employee> employee2 = countSubQuery.correlate(employee);

        //employee-phones join
        ListJoin<Employee, String> phoneNumbers = employee2.join(Employee_.phoneNumbers);

        //subquery selection
        countSubQuery.select(criteriaBuilder.count(phoneNumbers));

        //main query selection
        employeeQuery.select(employee)
             .where(criteriaBuilder.greaterThanOrEqualTo(countSubQuery, 2L));

        TypedQuery<Employee> typedQuery = entityManager.createQuery(employeeQuery);
        List<Employee> employees = typedQuery.getResultList();
        employees.forEach(System.out::println);
        entityManager.close();
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", "IT", 3000, "111-111-111", "222-111-111");
        Employee employee2 = Employee.create("Rose", "Admin", 2000, "333-111-111", "444-111-111");
        Employee employee3 = Employee.create("Denise", "Admin", 4000, "555-111-111");
        Employee employee4 = Employee.create("Mike", "IT", 3500, "777-111-111");
        Employee employee5 = Employee.create("Linda", "Sales", 2000);
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.persist(employee5);
        em.getTransaction().commit();
        em.close();
        System.out.println("-- all employees --");
        System.out.println(employee1);
        System.out.println(employee2);
        System.out.println(employee3);
        System.out.println(employee4);
        System.out.println(employee5);
    }
}