package com.logicbig.example;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneOffset;

@Entity
public class Employee {
    @Id
    @GeneratedValue
    private long id;
    private String name;
    private Timestamp joinDate;
    private long salary;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Timestamp getJoinDate() {
        return joinDate;
    }

    public void setJoinDate(Timestamp joinDate) {
        this.joinDate = joinDate;
    }

    public long getSalary() {
        return salary;
    }

    public void setSalary(long salary) {
        this.salary = salary;
    }

    public static Employee create(String name, int salary, LocalDate joinDate) {
        Employee employee = new Employee();
        employee.setName(name);
        employee.setSalary(salary);
        employee.setJoinDate(Timestamp.from(joinDate.atStartOfDay().toInstant(ZoneOffset.UTC)));
        return employee;
    }

    @Override
    public String toString() {
        return "Employee{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", joinDate=" + joinDate +
                ", salary=" + salary +
                '}';
    }
}