package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployeeWithEmploymentYears();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEmployeeWithEmploymentYears() {
        System.out.println("-- Employee name with employment years  --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Object[]> query = criteriaBuilder.createQuery(Object[].class);
        Root<Employee> employee = query.from(Employee.class);
        query.multiselect(employee.get(Employee_.name),
                criteriaBuilder.function("DATEDIFF", Long.class,
                        criteriaBuilder.literal("YEAR"),
                        employee.get(Employee_.JOIN_DATE),
                        criteriaBuilder.literal(Timestamp.valueOf(LocalDateTime.now()))
                ));
        List<Object[]> resultList = entityManager.createQuery(query).getResultList();
        resultList.forEach(arr -> System.out.println(Arrays.toString(arr)));
        entityManager.close();
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 3000, LocalDate.of(1999, 11, 15));
        Employee employee2 = Employee.create("Rose", 4000, LocalDate.of(2011, 5, 1));
        Employee employee3 = Employee.create("Denise", 1500, LocalDate.of(2006, 1, 10));
        Employee employee4 = Employee.create("Mike", 2000, LocalDate.of(2015, 8, 20));

        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.getTransaction().commit();
        em.close();
        System.out.println("-- employee persisted --");
        System.out.println(employee1);
        System.out.println(employee2);
        System.out.println(employee3);
        System.out.println(employee4);
    }
}