package com.logicbig.example;

import javax.persistence.*;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEntities();
            executeAllQuery();
            executeAnyQuery();
        } finally {
            entityManagerFactory.close();
        }
    }

    private static void executeAllQuery() {
        System.out.println("-- finding OrderItem which have qty > ALL inventories qty --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<OrderItem> orderItemQuery = criteriaBuilder.createQuery(OrderItem.class);
        Root<OrderItem> orderItem = orderItemQuery.from(OrderItem.class);

        Subquery<Integer> productInventorySubquery = orderItemQuery.subquery(Integer.class);
        Root<ProductInventory> productInventory = productInventorySubquery.from(ProductInventory.class);
        productInventorySubquery.select(productInventory.get(ProductInventory_.QUANTITY))
                                .where(criteriaBuilder.equal(productInventory.get(ProductInventory_.productName),
                                        orderItem.get(OrderItem_.productName)));

        orderItemQuery.select(orderItem).where(criteriaBuilder.greaterThan(
                orderItem.get(OrderItem_.QUANTITY), criteriaBuilder.all(productInventorySubquery)));

        TypedQuery<OrderItem> typedQuery = entityManager.createQuery(orderItemQuery);
        List<OrderItem> list = typedQuery.getResultList();
        list.forEach(System.out::println);
        entityManager.close();
    }

    private static void executeAnyQuery() {
        System.out.println("-- finding OrderItem which have qty > ANY inventories qty --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<OrderItem> orderItemQuery = criteriaBuilder.createQuery(OrderItem.class);
        Root<OrderItem> orderItem = orderItemQuery.from(OrderItem.class);

        Subquery<Integer> productInventorySubquery = orderItemQuery.subquery(Integer.class);
        Root<ProductInventory> productInventory = productInventorySubquery.from(ProductInventory.class);
        productInventorySubquery.select(productInventory.get(ProductInventory_.QUANTITY))
                                .where(criteriaBuilder.equal(productInventory.get(ProductInventory_.productName),
                                        orderItem.get(OrderItem_.productName)));

        orderItemQuery.select(orderItem).where(criteriaBuilder.greaterThan(
                orderItem.get(OrderItem_.QUANTITY), criteriaBuilder.any(productInventorySubquery)));

        TypedQuery<OrderItem> typedQuery = entityManager.createQuery(orderItemQuery);
        List<OrderItem> list = typedQuery.getResultList();
        list.forEach(System.out::println);
        entityManager.close();
    }

    public static void persistEntities() {
        System.out.println("-- persisting entities --");
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        getProductInventoryList().forEach(em::persist);
        getOrderItemList().forEach(em::persist);
        em.getTransaction().commit();

        System.out.println("-- entities persisted --");
        em.createQuery("SELECT p FROM ProductInventory p")
          .getResultList()
          .forEach(System.out::println);

        em.createQuery("SELECT o FROM OrderItem o")
          .getResultList()
          .forEach(System.out::println);
        em.close();

    }

    private static List<ProductInventory> getProductInventoryList() {
        List<ProductInventory> list = new ArrayList<>();
        list.add(ProductInventory.of("Monitor", 10, "Vritville"));
        list.add(ProductInventory.of("Monitor", 50, "Lonpore"));
        list.add(ProductInventory.of("Desktop Computer", 15, "Vritville"));
        list.add(ProductInventory.of("Desktop Computer", 20, "Lonpore"));
        list.add(ProductInventory.of("Laptop", 25, "Vritville"));
        list.add(ProductInventory.of("Laptop", 30, "Lonpore"));
        list.add(ProductInventory.of("SSD", 45, "Vritville"));
        list.add(ProductInventory.of("SSD", 30, "Lonpore"));
        return list;
    }

    private static List<OrderItem> getOrderItemList() {
        List<OrderItem> list = new ArrayList<>();
        list.add(OrderItem.of("Monitor", 60));
        list.add(OrderItem.of("Desktop Computer", 9));
        list.add(OrderItem.of("Laptop", 25));
        list.add(OrderItem.of("SSD", 40));
        return list;
    }
}