package com.logicbig.example;

import javax.persistence.*;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import java.math.BigDecimal;
import java.time.LocalDate;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            persistEmployees();
            findEmployeeCount();
            findEmployeeAvgSalary();
            findEmployeeMaxSalary();
            findEmployeeMinSalary();
            findEmployeeSalariesSum();
            findOldestJoinDate();
            findNewestJoinDate();
            findGreatestNameAlphabetically();
            findLeastNameAlphabetically();

        } finally {
            entityManagerFactory.close();
        }
    }

    private static void findEmployeeCount() {
        System.out.println("-- Employee COUNT --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Long> query = criteriaBuilder.createQuery(Long.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.count(employee));
        TypedQuery<Long> typedQuery = entityManager.createQuery(query);
        Long count = typedQuery.getSingleResult();
        System.out.println(count);
        entityManager.close();
    }

    private static void findEmployeeAvgSalary() {
        System.out.println("-- Employee AVG Salary --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Double> query = criteriaBuilder.createQuery(Double.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.avg(employee.get(Employee_.salary)));
        TypedQuery<Double> typedQuery = entityManager.createQuery(query);
        Double average = typedQuery.getSingleResult();
        System.out.println(average);
        entityManager.close();
    }

    private static void findEmployeeMaxSalary() {
        System.out.println("-- Employee MAX Salary --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Long> query = criteriaBuilder.createQuery(Long.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.max(employee.get(Employee_.salary)));
        TypedQuery<Long> typedQuery = entityManager.createQuery(query);
        Long max = typedQuery.getSingleResult();
        System.out.println(max);
        entityManager.close();
    }

    private static void findEmployeeMinSalary() {
        System.out.println("-- Employee MIN Salary --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Long> query = criteriaBuilder.createQuery(Long.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.min(employee.get(Employee_.salary)));
        TypedQuery<Long> typedQuery = entityManager.createQuery(query);
        Long min = typedQuery.getSingleResult();
        System.out.println(min);
        entityManager.close();
    }

    private static void findEmployeeSalariesSum() {
        System.out.println("-- Employee SUM Salary --");
        EntityManager em = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery<BigDecimal> query = criteriaBuilder.createQuery(BigDecimal.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.sum(employee.get(Employee_.salary).as(BigDecimal.class)));
        TypedQuery<BigDecimal> typedQuery = em.createQuery(query);
        BigDecimal sum = typedQuery.getSingleResult();
        System.out.println(sum);
        em.close();
    }

    private static void findOldestJoinDate() {
        System.out.println("-- oldest join date --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<LocalDate> query = criteriaBuilder.createQuery(LocalDate.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.least(employee.get(Employee_.joinDate)));
        TypedQuery<LocalDate> typedQuery = entityManager.createQuery(query);
        LocalDate least = typedQuery.getSingleResult();
        System.out.println(least);
        entityManager.close();
    }

    private static void findNewestJoinDate() {
        System.out.println("-- newest join date --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<LocalDate> query = criteriaBuilder.createQuery(LocalDate.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.greatest(employee.get(Employee_.joinDate)));
        TypedQuery<LocalDate> typedQuery = entityManager.createQuery(query);
        LocalDate greatest = typedQuery.getSingleResult();
        System.out.println(greatest);
        entityManager.close();
    }


    private static void findGreatestNameAlphabetically() {
        System.out.println("-- greatest name alphabetically --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<String> query = criteriaBuilder.createQuery(String.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.greatest(employee.get(Employee_.name)));
        TypedQuery<String> typedQuery = entityManager.createQuery(query);
        String greatest = typedQuery.getSingleResult();
        System.out.println(greatest);
        entityManager.close();
    }

    private static void findLeastNameAlphabetically() {
        System.out.println("-- least name alphabetically --");
        EntityManager entityManager = entityManagerFactory.createEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<String> query = criteriaBuilder.createQuery(String.class);
        Root<Employee> employee = query.from(Employee.class);
        query.select(criteriaBuilder.least(employee.get(Employee_.name)));
        TypedQuery<String> typedQuery = entityManager.createQuery(query);
        String least = typedQuery.getSingleResult();
        System.out.println(least);
        entityManager.close();
    }

    public static void persistEmployees() {
        Employee employee1 = Employee.create("Diana", 3000, LocalDate.of(1999, 6, 1));
        Employee employee2 = Employee.create("Rose", 4000, LocalDate.of(2005, 2, 1));
        Employee employee3 = Employee.create("Denise", 1500, LocalDate.of(2011, 1, 1));
        Employee employee4 = Employee.create("Mike", 2000, LocalDate.of(2007, 8, 1));
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(employee1);
        em.persist(employee2);
        em.persist(employee3);
        em.persist(employee4);
        em.getTransaction().commit();
        em.close();
        System.out.println("-- all employees --");
        System.out.println(employee1);
        System.out.println(employee2);
        System.out.println(employee3);
        System.out.println(employee4);
    }
}