package com.logicbig.example;

import javax.persistence.*;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@Entity
public class Journal {
    @Id
    @GeneratedValue
    private long id;
    @ElementCollection
    private Map<String, Report> reportMap;

    public Map<String, Report> getReportMap() {
        return reportMap;
    }

    public void addReport(String reportName, String description, File file) {
        if (reportMap == null) {
            reportMap = new HashMap<>();
        }
        Report report = new Report();
        report.setDescription(description);
        report.setFile(file);
        reportMap.put(reportName, report);
    }

    @Override
    public String toString() {
        return "Journal{" +
                "id=" + id +
                ", reportMap=" + reportMap +
                '}';
    }
}