package com.logicbig.example;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class ExampleMain {
    private static EntityManagerFactory entityManagerFactory =
            Persistence.createEntityManagerFactory("example-unit");

    public static void main(String[] args) {
        try {
            nativeQuery("Show Columns from Journal");
            nativeQuery("Show Columns from Journal_ReportMap");
            persistEntity();
            nativeQuery("Select * from Journal");
            nativeQuery("Select * from Journal_ReportMap");
            loadEntity();
        } finally {
            entityManagerFactory.close();
        }
    }

    public static void persistEntity() {
        Journal journal = new Journal();
        journal.addReport("name1", "test report 1", new File("c:/temp/report-1.txt"));
        journal.addReport("name2", "test report 2", new File("c:/temp/report-2.txt"));
        System.out.println("Persisting journal: " + journal);
        EntityManager em = entityManagerFactory.createEntityManager();
        em.getTransaction().begin();
        em.persist(journal);
        em.getTransaction().commit();
        em.close();
    }

    private static void loadEntity() {
        EntityManager em = entityManagerFactory.createEntityManager();
        Journal journal = em.find(Journal.class, 1L);
        System.out.println("Journal loaded: " + journal);
        em.close();
    }

    public static void nativeQuery(String s) {
        EntityManager em = entityManagerFactory.createEntityManager();
        System.out.printf("'%s'%n", s);
        Query query = em.createNativeQuery(s);
        List list = query.getResultList();
        for (Object o : list) {
            if (o instanceof Object[]) {
                System.out.println(Arrays.toString((Object[]) o));
            } else {
                System.out.println(o);
            }
        }
        em.close();
    }
}