package com.logicbig.example;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;

@WebServlet(urlPatterns = "/test")
public class MyServlet extends HttpServlet {

    @Override
    protected void doGet (HttpServletRequest req,
                          HttpServletResponse resp)
              throws ServletException, IOException {

        String eTagFromBrowser = req.getHeader("If-None-Match");
        String eTagFromServer = getETag();

        if (eTagFromServer.equals(eTagFromBrowser)) {
            //setting 304 and returning with empty body
            resp.setStatus(HttpServletResponse.SC_NOT_MODIFIED);
            return;
        }

        resp.addHeader("ETag", getETag());
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        writer.write("<h4>My Servlet</h4>");
        writer.write(LocalDateTime.now().toString());
        writer.write("<br/><a href='test'>test</a>");
    }

    private String getETag () {
        //Using hard coded value, in real scenario this value might be auto-generated
        //from the resource content, for example, by using a hash function.
        return "\"version1\"";
    }
}