package com.logicbig.examples.json.streaming;

import org.fluttercode.datafactory.impl.DataFactory;

import javax.json.Json;
import javax.json.stream.JsonGenerator;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class StreamWriter {

    private static final Logger LOGGER = Logger.getLogger(StreamWriter.class.getName());
    private final OutputStream outputStream;

    public StreamWriter(OutputStream outputStream) {

        this.outputStream = outputStream;
    }

    public void startWriting() {
        Executors.newSingleThreadExecutor().submit(() -> generateAndOuputJSON());
    }

    private void generateAndOuputJSON() {
        DataFactory dataFactory = new DataFactory();

        try (JsonGenerator generator = Json.createGenerator(outputStream)) {
            JsonGenerator arrayGenerator = generator.writeStartArray();
            for (int i = 0; i < 1000; i++) {

                arrayGenerator.writeStartObject()
                        .write("order-id", i)
                        .write("order-quantity", dataFactory.getNumberBetween(1, 100))
                        .write("item-id", dataFactory.getNumberBetween(1, 1000))
                        .write("order-date", dataFactory.getDateBetween(new Date(1000000), new Date()).toString())
                        .writeStartArray("customer-info")
                        .writeStartObject()
                        .write("customer-id", dataFactory.getNumberBetween(1, 1000))
                        .write("address", dataFactory.getAddress() + ", " + dataFactory.getCity())
                        .write("email", dataFactory.getEmailAddress())
                        .writeEnd()
                        .writeEnd()
                        .writeEnd();
                LOGGER.info("\n----------Wrote array index " + i + " ------------\n");
                try {
                    Thread.sleep(50);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            arrayGenerator.writeEnd();
        }
    }
}