package com.logicbig.example;

import javax.validation.*;
import java.util.Set;

public class ConstraintGroupSequenceExample {
    private static final Validator validator;

    static {
        Configuration<?> config = Validation.byDefaultProvider().configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        validator = factory.getValidator();
        factory.close();
    }

    public static void main (String[] args) {
        User user = new User();

        Set<ConstraintViolation<User>> constraintViolations =
                            validator.validate(user, GroupSequenceForUser.class);

        if (constraintViolations.size() > 0) {
            constraintViolations.stream().forEach(
                                ConstraintGroupSequenceExample::printError);
        } else {
            //proceed using user object
            System.out.println(user);
        }
    }

    private static void printError (ConstraintViolation<User> violation) {
        System.out.println(violation.getPropertyPath() + " " + violation.getMessage());
    }
}