package com.logicbig.example;

import javax.validation.*;
import java.util.Set;

public class ConstraintGroupExample3 {
    private static final Validator validator;

    static {
        Configuration<?> config = Validation.byDefaultProvider().configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        validator = factory.getValidator();
        factory.close();
    }

    public static void main (String[] args) {
        User user = new User();
        user.setFirstName("Jennifer");
        //  user.setLastName("Wilson");

        Set<ConstraintViolation<User>> constraintViolations =
                            validator.validate(user);

        if (constraintViolations.size() > 0) {
            constraintViolations.stream().forEach(
                                ConstraintGroupExample3::printError);
        } else {
            //proceed using user object
            System.out.println(user);
        }
    }

    private static void printError (ConstraintViolation<User> violation) {
        System.out.println(violation.getPropertyPath() + " " + violation.getMessage());
    }
}