package com.logicbig.example;

import javax.validation.Valid;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.groups.ConvertGroup;

public class DriverLicense {
    @NotNull
    @Valid
    @ConvertGroup(from = LicenceNumberCheck.class,
            to = DriverPhysicalRequirement.class)
    private Driver driver;
    @Digits(integer = 7, fraction = 0, groups = LicenceNumberCheck.class)
    private int number;

    public DriverLicense(Driver driver, int number) {
        this.driver = driver;
        this.number = number;
    }
}