package com.logicbig.example;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import java.util.Date;

public class Driver {
    @NotNull
    private String fullName;
    @Min(value = 100, groups = DriverPhysicalRequirement.class)
    private int height;
    @Past(groups = DriverPhysicalRequirement.class)
    @NotNull
    private Date dateOfBirth;

    public Driver(String fullName, int height, Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        this.fullName = fullName;
        this.height = height;
    }
}