package com.logicbig.example;

import javax.validation.*;
import javax.validation.groups.Default;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;

public class ConvertGroupExample {

    public static void main(String[] args) throws ParseException {
        Driver driver = new Driver(null, 60,
                new Date(System.currentTimeMillis() + 100000));
        DriverLicense dl = new DriverLicense(driver, 3454343);

        Validator validator = createValidator();
        Set<ConstraintViolation<DriverLicense>> violations =
                validator.validate(dl, LicenceNumberCheck.class, Default.class);
        if (violations.size() == 0) {
            System.out.println("No violations.");
        } else {
            System.out.printf("%s violations:%n", violations.size());
            violations.stream()
                      .sorted(Comparator.comparing(o -> o.getPropertyPath().toString()))
                      .forEach(ConvertGroupExample::printError);
        }
    }

    public static void printError(ConstraintViolation<?> violation) {
        System.out.println(violation.getPropertyPath()
                + " " + violation.getMessage());
    }

    public static Validator createValidator() {
        Configuration<?> config = Validation.byDefaultProvider().configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator validator = factory.getValidator();
        factory.close();
        return validator;
    }
}