package com.logicbig.example;

import javax.validation.*;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Set;

public class ConstraintPayloadExample {
    private static final Validator validator;

    static {
        Configuration<?> config = Validation.byDefaultProvider().configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        validator = factory.getValidator();
        factory.close();
    }

    public static class Severity {
        public static class Info implements Payload {
        }

        public static class Error implements Payload {
        }
    }

    public static class TestBean {
        @NotNull(payload = {Severity.Error.class})
        @Size(min = 1, payload = {Severity.Info.class})
        private String str;

        public String getStr () {
            return str;
        }

        public void setStr (String str) {
            this.str = str;
        }
    }

    public static void main (String[] args) {
        TestBean bean = new TestBean();
        //uncommenting next line will give us info severity
        // or setting an non-empty string won't give any validation error
        //bean.setStr("");

        Set<ConstraintViolation<TestBean>> constraintViolations =
                            validator.validate(bean);

        boolean severeError = false;

        if (constraintViolations.size() > 0) {
            for (ConstraintViolation<TestBean> violation : constraintViolations) {
                Set<Class<? extends Payload>> payloads =
                                    violation.getConstraintDescriptor().getPayload();
                for (Class<? extends Payload> payload : payloads) {
                    if (payload == Severity.Error.class) {
                        severeError = true;
                        System.out.println("Error: " + violation.getPropertyPath() + " " +
                                            violation.getMessage());
                    } else if (payload == Severity.Info.class) {
                        System.out.println("Info: " + violation.getPropertyPath() + " " +
                                            violation.getMessage());
                    }
                }
            }
        }

        if (!severeError) {
            //continue working with bean
            System.out.println("working with : " + bean);
        }
    }

}