package com.logicbig.example;

import javax.validation.*;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;

public class WithoutValidAnnotationExample {

    private static class DriverLicense {
        @NotNull
        private Driver driver;
        @Digits(integer = 7, fraction = 0)
        private int number;

        public DriverLicense(Driver driver, int number) {
            this.driver = driver;
            this.number = number;
        }
    }

    private static class Driver {
        @NotNull
        private String fullName;
        @Min(100)
        private int height;
        @Past
        @NotNull
        private Date dateOfBirth;

        public Driver(String fullName, int height, Date dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            this.fullName = fullName;
            this.height = height;
        }
    }

    public static void main(String[] args) throws ParseException {
        Driver driver = new Driver("Joseph Waters", 60,
                new Date(System.currentTimeMillis() + 100000));
        DriverLicense dl = new DriverLicense(driver, 3454343);

        Validator validator = createValidator();
        Set<ConstraintViolation<DriverLicense>> violations = validator.validate(dl);
        if (violations.size() == 0) {
            System.out.println("No violations.");
        } else {
            System.out.printf("%s violations:%n", violations.size());
            violations.stream()
                      .forEach(WithoutValidAnnotationExample::printError);
        }
    }

    private static void printError(ConstraintViolation<?> violation) {
        System.out.println(violation.getPropertyPath()
                + " " + violation.getMessage());
    }

    public static Validator createValidator() {
        Configuration<?> config = Validation.byDefaultProvider().configure();
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator validator = factory.getValidator();
        factory.close();
        return validator;
    }
}