package com.logicbig.example;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;

public class ToggleButtonsGroupExample {
    public static void main(String[] args) {
        UIManager.put("ToggleButton.select", new Color(190, 186, 164));
        JFrame frame = createFrame();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel buttonPanel = new JPanel();
        ActionListener listener = actionEvent ->
                System.out.println(actionEvent.getActionCommand() + " Selected");
        for (int i = 0; i < 5; i++) {
            JToggleButton b = new JToggleButton(Integer.toString(i + 1));
            b.addActionListener(listener);
            buttonGroup.add(b);
            buttonPanel.add(b);
        }
        frame.add(buttonPanel, BorderLayout.NORTH);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("JToggleButton Group example");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(new Dimension(600, 300));
        return frame;
    }
}