package com.logicbig.example;

import com.logicbig.uicommon.DisplayableObjectTableModel;
import com.logicbig.uicommon.ObjectTableModel;
import com.logicbig.util.RandomUtil;
import javax.swing.*;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;

public class ExampleMain {
    public static void main(String[] args) {
        JFrame frame = createFrame();
        ObjectTableModel<Employee> tableModel = new DisplayableObjectTableModel<>(Employee.class);
        tableModel.setObjectRows(getEmployees());
        JTable table = new JTable(tableModel);
        initDeptComboBoxEditor(table);
        JScrollPane pane = new JScrollPane(table);
        frame.add(pane);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private static void initDeptComboBoxEditor(JTable table) {
        JComboBox comboBox = new JComboBox(Employee.DEPT_LIST);
        DefaultCellEditor editor = new DefaultCellEditor(comboBox);
        TableColumn column = table.getColumnModel().getColumn(Employee.DEPT_INDEX);
        column.setCellEditor(editor);
    }

    public static List<Employee> getEmployees() {
        final List<Employee> list = new ArrayList<>();
        for (int i = 1; i <= 20; i++) {
            Employee e = new Employee();
            e.setName(RandomUtil.getFullName());
            e.setPhone(Integer.toString(RandomUtil.getInt(111111111, 999999999)));
            e.setDept(RandomUtil.getAnyOf(Employee.DEPT_LIST));
            e.setFullTime(RandomUtil.getBoolean());
            e.setDateOfBirth(RandomUtil.getDate(1950, 2000));
            list.add(e);
        }
        return list;
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("Editable JTable example");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(new Dimension(600, 300));
        return frame;
    }
}