package com.logicbig.example;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class URLConnectionClient2 {
    public static void main(String[] args) throws Exception {
        URL myURL = new URL("http://localhost:8080");
        URLConnection c = myURL.openConnection();

        String authStr = Base64.getEncoder()
                               .encodeToString("Tom:abc".getBytes());
        //setting Authorization header
        c.setRequestProperty("Authorization", "Basic " + authStr);
        Map<String, List<String>> headers = c.getHeaderFields();
        System.out.println("-- Response headers --");
        headers.entrySet()
               .forEach(e -> System.out.printf("%s: %s%n", e.getKey(), e.getValue()));

        System.out.println("-- Response body --");
        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(c.getInputStream()))) {
            reader.lines().forEach(System.out::println);
        }
    }
}