package com.logicbig.example;

import javax.tools.*;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class StringCompilation {

    public static void main(String[] args) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

        DiagnosticCollector<JavaFileObject> diagnostics =
                                         new DiagnosticCollector<>();

        JavaCompiler.CompilationTask task = compiler.getTask(null,
                null, diagnostics, null, null, getCompilationUnits());

        if (!task.call()) {
            diagnostics.getDiagnostics().forEach(System.out::println);
        }

        //loading and using our compiled class
        Class<ITest> test = (Class<ITest>) Class.forName("Test");
        ITest iTest = test.newInstance();
        iTest.doSomething();
    }

    public static Iterable<? extends JavaFileObject> getCompilationUnits() {
        JavaStringObject stringObject =
                                   new JavaStringObject("Test", getSource());
        return Arrays.asList(stringObject);
    }

    public static String getSource() {
        return "public class Test implements com.logicbig.example.ITest{" +
                "public void doSomething(){" +
                "System.out.println(\"testing\");}}";
    }
}