package com.logicbig.example;

import static com.logicbig.example.RegexUtil.test;

public class RegexExamples {

    public static void main(String[] args) {
        //++ possessive quantifier
        test(".++", "abc");
        test(".++x", "abcx");

        /* Making it greedy */
        test(".+x", "abcx");
        test("x++", "xxbxxx");
         /* Making it reluctant */
        test("x+?", "xxbxxx");
        test("A.++", "AEG");
        test("((cat)|(dog))++", "cat dog catdog dogcat");
        /* Making it reluctant */
        test("((cat)|(dog))+?", "cat dog catdog dogcat");

        //*+ possessive quantifier
        test(".*+", "");
        test(".*+x", "abcx");
        test("x*+", "xxbxx");
        test("x*?", "xxbxx");
        ;
        test("a.*+z", "abztstz");
        test("a*+z", "abztstaz");
        test("a*+z", "aaaaaaa");
        test("a*+z?", "aaaaaaa");
        test("'[^']*+'", "'Reason and Rationality'");

        //?+ possessive quantifier
        test(".?+", "");
        test(".?+", "abc");
        test(".?+x", "yyyyx");
        test(".?+x", "x");
        test("x?+", "xyz");
        test("x?+z", "xyzyzzxyxzy");

        //{}+ possessive quantifer
        test(".{3,}+", "abcd");
        test("a.{0,}+z", "abcdz");
        test(".*+abc", "aabc");
    }
}