package com.logicbig.example;

import static com.logicbig.example.RegexUtil.*;

public class LookAheadExample {

    public static void main(String[] args) {
        //positive lookahead after
        test("[a-z]+,", "bat, cat, dog, fox");
        test("[a-z]+(?=,)", "bat, cat, dog, fox");
        test("[a-z](?=[0-9])", "a7 bb");
        test("\\d+(?=\\scm)", "200 cm");
        test("[a-z]+(?=s)", "ages mix uses woes");
        test("[a-z]+?(?=s)", "ages mix uses woes");
        test("[a-z](?=i)", "bit car biz ice");
        test(".(?=i)", "bit cat biz ice");
        test("[a-z](?=\\s)", "bit cat biz ice");
        test("[a-z](?=[0-9]|[a-d])", "a10 c2 a1 ez dd");
        test("[a-z](?=1)", "a10 a1 1 a a");
        test("[a-z](?=1\\s)", "a10 a1 1 a a");

        //positive lookahead before
        test("(?=[a-z][0-9])[a-z]", "a7 bb");
        test("(?=[a-z][0-9][a-z])[a-z]", "a7a bbb 9z9");
        test("(?=[a-z][0-9])[0-9]", "7a bc d8 9w");
        test("(?=[a-z][0-9])d[0-9]", "7a bc c6 d8 9w");
        test("(?=[a-z]|[0-9])[0-9]", "7a bc c6 d8 9w");
        test("(?=\\d+\\scm)\\d+", "200 cm");
        test("(?=(\\d+)\\scm)\\1", "200 cm");
        test("(?=([a-z]+)[0-9])\\1", "ere7 zcbc8 c6 dcd 9ddw4");
        test("(?=\\d+ thousand(?= dollars))\\d+", "20 thousand dollars.");
        test("(?=\\d+ (thousand|hundred)(?= dollars))\\d+", "20 hundred dollars.");
        test("(?=\\d+ ([a-z]+)(?= dollars))\\d+", "20 million dollars.");
        test("[a-z]+(?=d\\b)", "food stand boss eyed funny");
        test("(?=[a-z]+d\\b)[a-z]+","food stand boss eyed funny");

        //negative lookahead after
        test("[a-z](?![0-9])", "a9 c2 a1 dd");
        test("[a-z](?![0-9]|[a-k])", "a9 c2 a1 dd");
        test("[a-z]+(?!,)", "bat, cat, dog, fox");
        test("X(?!Y(?!Z))", "XYZ XY YZ XZ XA");
        test("X(?!Y(?=Z))", "XYZ XY YZ XZ XA");
        test("X(?=Y(?!Z))", "XYZ XY YZ XZ XA");

        //Negative lookahead before
        test("(?![a-z][0-9])[a-z]", "a9 c2 a1 dd");
        test("^(?!.*?(bad|worse)).*", "This is a good idea");
        test("^(?!.*?(bad|worse)).*", "This is a worse idea");
        test("^(?!.*?(?:bad|worse)).*", "This is a good idea.");
        test("^(?!.*\\/jars\\/temp\\/).*\\.jar$", "/abc/jars/temp/util.jar");
        test("^(?!.*\\/jars\\/temp\\/).*\\.jar$", "/abc/jars/app/parser.jar");
        test("^(?!.*Component\\.java$).*\\.java$", "String.java");
        test("^(?!.*Component\\.java$).*\\.java$", "JComponent.java");
    }
}