package com.logicbig.example;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class CompactNumberFormatExplicitRounding {
    public static void main(String[] args) {
        formatForLocale(Locale.US);
    }

    private static void formatForLocale(Locale locale) {
        List<Integer> numbers = List.of(1500, 1500000, 1200000000);
        System.out.printf("-- SHORT format for locale=%s --%n", locale);
        numbers.stream().forEach((num) -> {
            NumberFormat nf = NumberFormat.getCompactNumberInstance(locale, NumberFormat.Style.SHORT);
            nf.setRoundingMode(RoundingMode.HALF_DOWN);
            String format = nf.format(num);
            System.out.println(format);
        });
        System.out.printf("-- LONG format for locale=%s --%n", locale);
        numbers.stream().forEach((num) -> {
            NumberFormat nf = NumberFormat.getCompactNumberInstance(locale, NumberFormat.Style.LONG);
            nf.setRoundingMode(RoundingMode.HALF_DOWN);
            String format = nf.format(num);
            System.out.println(format);
        });
    }
}