package com.logicbig.example;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class CompactNumberFormatParseWithGrouping {
    public static void main(String[] args) throws ParseException {
        parseWithGrouping(false);
        parseWithGrouping(true);
    }

    private static void parseWithGrouping(boolean grouping) throws ParseException {
        System.out.printf("-- grouping=%s  ---%n", grouping);
        NumberFormat nf = NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT);
        nf.setGroupingUsed(grouping);
        Number num = nf.parse("1,00K");
        System.out.println(num);
        num = nf.parse("1,00M");
        System.out.println(num);
        num = nf.parse("1,00B");
        System.out.println(num);
    }
}