package com.logicbig.example;

import java.io.*;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileReaderWriterCharsetExample {
    public static void main(String[] args) throws IOException {
        Path path = Files.createTempFile("test", ".txt");
        File targetFile = path.toFile();
        targetFile.deleteOnExit();

        Charset latinCharset = Charset.forName("ISO-8859-3");
        //FileWriter new constructor
        FileWriter fw = new FileWriter(targetFile, latinCharset);
        fw.write("test filum");
        fw.close();;
        //FileReader new constructor
        FileReader fr = new FileReader(targetFile, latinCharset);
        new BufferedReader(fr).lines().forEach(System.out::println);
        fr.close();
    }
}