package com.logicbig.example;

import java.io.*;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class NullWriterExample {
    public static void main(String[] args) throws IOException {
        Writer writer1 = new StringWriter();
        Writer writer2 = Writer.nullWriter();//new method
        Writer writer3 = new CharArrayWriter();
        List<Writer> list = List.of(writer1, writer2, writer3);
        writeData(list);

        //just check the buf content via toString
        list.forEach(writer -> {
            //toString prints underlying data buffer -
            //nullWriter has no buffer and does not override toString
            System.out.printf("writer type: %s, toString: %s%n",
                    writer.getClass().getSimpleName(),
                    writer.toString());
        });
    }

    public static void writeData(List<Writer> writers) throws IOException {
        for (Writer writer : writers) {
            writer.write(Integer.toString(ThreadLocalRandom.current().nextInt()));
            writer.close();
        }
    }
}